/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.world.saved_data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber(modid="ars_nouveau")
public class RedstoneSavedData
extends SavedData {
    public final Map<BlockPos, Entry> SIGNAL_MAP = new HashMap<BlockPos, Entry>();

    public static SavedData.Factory<RedstoneSavedData> factory() {
        return new SavedData.Factory(RedstoneSavedData::new, RedstoneSavedData::load, null);
    }

    public static RedstoneSavedData load(CompoundTag tag, HolderLookup.Provider p_323806_) {
        RedstoneSavedData data = new RedstoneSavedData();
        ListTag signalList = tag.getList("SignalList", 10);
        for (int i = 0; i < signalList.size(); ++i) {
            Entry signal = new Entry(signalList.getCompound(i));
            data.SIGNAL_MAP.put(signal.pos, signal);
        }
        return data;
    }

    public void tick(ServerLevel serverLevel) {
        ArrayList<BlockPos> toRemove = new ArrayList<BlockPos>();
        for (Entry signal : this.SIGNAL_MAP.values()) {
            if (!serverLevel.isLoaded(signal.pos) || signal.ticks-- > 0) continue;
            toRemove.add(signal.pos);
        }
        for (BlockPos pos : toRemove) {
            this.SIGNAL_MAP.remove(pos);
            serverLevel.getBlockState(pos).onNeighborChange((LevelReader)serverLevel, pos, pos);
            serverLevel.updateNeighborsAt(pos, serverLevel.getBlockState(pos).getBlock());
        }
    }

    public boolean isDirty() {
        return true;
    }

    public CompoundTag save(CompoundTag pCompoundTag, HolderLookup.Provider pRegistries) {
        ListTag signalList = new ListTag();
        for (Entry signal : this.SIGNAL_MAP.values()) {
            signalList.add((Object)signal.save(new CompoundTag()));
        }
        pCompoundTag.put("SignalList", (Tag)signalList);
        return pCompoundTag;
    }

    public static RedstoneSavedData from(ServerLevel level) {
        return (RedstoneSavedData)level.getDataStorage().computeIfAbsent(RedstoneSavedData.factory(), "an_redstone_signals");
    }

    @SubscribeEvent
    public static void serverTick(LevelTickEvent.Post e) {
        if (e.getLevel().isClientSide) {
            return;
        }
        RedstoneSavedData data = RedstoneSavedData.from((ServerLevel)e.getLevel());
        data.tick((ServerLevel)e.getLevel());
    }

    public static class Entry {
        public BlockPos pos;
        public int power;
        public int ticks;

        public Entry(BlockPos pos, int power, int ticks) {
            this.pos = pos;
            this.power = power;
            this.ticks = ticks;
        }

        public Entry(CompoundTag tag) {
            this(new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z")), tag.getInt("power"), tag.getInt("ticks"));
        }

        public CompoundTag save(CompoundTag tag) {
            tag.putInt("x", this.pos.getX());
            tag.putInt("y", this.pos.getY());
            tag.putInt("z", this.pos.getZ());
            tag.putInt("power", this.power);
            tag.putInt("ticks", this.ticks);
            return tag;
        }
    }
}

